/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.AbilityType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.game.permanent.PermanentToken;
import mage.util.CardUtil;
import mage.util.functions.CopyApplier;

public class CopyEffect
extends ContinuousEffectImpl {
    protected MageObject copyFromObject;
    protected UUID copyToObjectId;
    protected CopyApplier applier;

    public CopyEffect(MageObject copyFromObject, UUID copyToObjectId) {
        this(Duration.Custom, copyFromObject, copyToObjectId);
    }

    public CopyEffect(Duration duration, MageObject copyFromObject, UUID copyToObjectId) {
        super(duration, Layer.CopyEffects_1, SubLayer.CopyEffects_1a, Outcome.BecomeCreature);
        this.copyFromObject = copyFromObject;
        this.copyToObjectId = copyToObjectId;
    }

    protected CopyEffect(CopyEffect effect) {
        super(effect);
        this.copyFromObject = effect.copyFromObject.copy();
        this.copyToObjectId = effect.copyToObjectId;
        this.applier = effect.applier;
    }

    @Override
    public void init(Ability source, Game game) {
        Permanent permanent;
        super.init(source, game);
        if (!(this.copyFromObject instanceof Permanent) && this.copyFromObject instanceof Card) {
            Card newBluePrint = CardUtil.getDefaultCardSideForBattlefield(game, (Card)this.copyFromObject);
            this.copyFromObject = new PermanentCard(newBluePrint, source.getControllerId(), game);
        }
        if ((permanent = game.getPermanent(this.copyToObjectId)) != null) {
            this.affectedObjectList.add(new MageObjectReference(permanent, game));
        } else if (source.getAbilityType() == AbilityType.STATIC && (permanent = game.getPermanentEntering(this.copyToObjectId)) != null) {
            this.copyToPermanent(permanent, game, source);
            int ZCCDiff = 1;
            if (permanent instanceof PermanentToken) {
                ZCCDiff = 0;
            }
            this.affectedObjectList.add(new MageObjectReference(permanent.getId(), game.getState().getZoneChangeCounter(this.copyToObjectId) + ZCCDiff, game));
        }
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (this.affectedObjectList.isEmpty()) {
            this.discard();
            return false;
        }
        Permanent permanent = ((MageObjectReference)this.affectedObjectList.get(0)).getPermanent(game);
        if (permanent == null) {
            if (!game.checkShortLivingLKI(this.getSourceId(), Zone.BATTLEFIELD)) {
                this.discard();
                return false;
            }
            permanent = (Permanent)game.getLastKnownInformation(this.getSourceId(), Zone.BATTLEFIELD, source.getStackMomentSourceZCC());
            if (permanent == null) {
                this.discard();
                return false;
            }
        }
        return this.copyToPermanent(permanent, game, source);
    }

    protected boolean copyToPermanent(Permanent permanent, Game game, Ability source) {
        if (this.copyFromObject.getCopyFrom() != null) {
            permanent.setCopy(true, this.copyFromObject.getCopyFrom());
        } else {
            permanent.setCopy(true, this.copyFromObject);
        }
        permanent.setName(this.copyFromObject.getName());
        permanent.getColor(game).setColor(this.copyFromObject.getColor(game));
        permanent.getManaCost().clear();
        permanent.getManaCost().add(this.copyFromObject.getManaCost().copy());
        permanent.removeAllCardTypes(game);
        for (CardType cardType : this.copyFromObject.getCardType(game)) {
            permanent.addCardType(game, cardType);
        }
        permanent.removeAllSubTypes(game);
        permanent.copySubTypesFrom(game, this.copyFromObject);
        permanent.removeAllSuperTypes(game);
        for (SuperType superType : this.copyFromObject.getSuperType(game)) {
            permanent.addSuperType(game, superType);
        }
        permanent.removeAllAbilities(source.getSourceId(), game);
        if (this.copyFromObject instanceof Permanent) {
            for (Ability ability : ((Permanent)this.copyFromObject).getAbilities(game)) {
                permanent.addAbility(ability, this.getSourceId(), game, true);
            }
        } else {
            for (Ability ability : this.copyFromObject.getAbilities()) {
                permanent.addAbility(ability, this.getSourceId(), game, true);
            }
        }
        permanent.getPower().setModifiedBaseValue(this.copyFromObject.getPower().getModifiedBaseValue());
        permanent.getToughness().setModifiedBaseValue(this.copyFromObject.getToughness().getModifiedBaseValue());
        permanent.setStartingLoyalty(this.copyFromObject.getStartingLoyalty());
        permanent.setStartingDefense(this.copyFromObject.getStartingDefense());
        if (this.copyFromObject instanceof Permanent) {
            Permanent targetPermanent = (Permanent)this.copyFromObject;
            permanent.setFlipCard(targetPermanent.isFlipCard());
            permanent.setFlipCardName(targetPermanent.getFlipCardName());
            permanent.setPrototyped(targetPermanent.isPrototyped());
        }
        CardUtil.copySetAndCardNumber(permanent, this.copyFromObject);
        return true;
    }

    @Override
    public CopyEffect copy() {
        return new CopyEffect(this);
    }

    public MageObject getTarget() {
        return this.copyFromObject;
    }

    public void setTarget(MageObject target) {
        this.copyFromObject = target;
    }

    public UUID getSourceId() {
        return this.copyToObjectId;
    }

    public CopyApplier getApplier() {
        return this.applier;
    }

    public CopyEffect setApplier(CopyApplier applier) {
        this.applier = applier;
        return this;
    }
}

