/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.util.CardUtil;
import mage.util.functions.StackObjectCopyApplier;

public class CopyTargetStackObjectEffect
extends OneShotEffect {
    private final boolean useController;
    private final boolean useLKI;
    private String objectName = "that spell";
    private final boolean chooseTargets;
    private final int amount;
    private final StackObjectCopyApplier applier;

    public CopyTargetStackObjectEffect() {
        this(false);
    }

    public CopyTargetStackObjectEffect(boolean useLKI) {
        this(false, useLKI, true);
    }

    public CopyTargetStackObjectEffect(boolean useController, boolean useLKI, boolean chooseTargets) {
        this(useController, useLKI, chooseTargets, 1, null);
    }

    public CopyTargetStackObjectEffect(boolean useController, boolean useLKI, boolean chooseTargets, int amount, StackObjectCopyApplier applier) {
        super(Outcome.Copy);
        this.useController = useController;
        this.useLKI = useLKI;
        this.chooseTargets = chooseTargets;
        this.amount = amount;
        this.applier = applier;
    }

    protected CopyTargetStackObjectEffect(CopyTargetStackObjectEffect effect) {
        super(effect);
        this.useLKI = effect.useLKI;
        this.useController = effect.useController;
        this.objectName = effect.objectName;
        this.chooseTargets = effect.chooseTargets;
        this.amount = effect.amount;
        this.applier = effect.applier;
    }

    public CopyTargetStackObjectEffect withText(String objectName) {
        this.objectName = objectName;
        return this;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        StackObject stackObject = this.useLKI ? game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source)) : game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        if (stackObject == null) {
            stackObject = (StackObject)game.getLastKnownInformation(this.getTargetPointer().getFirst(game, source), Zone.STACK);
        }
        if (stackObject != null) {
            stackObject.createCopyOnStack(game, source, this.useController ? stackObject.getControllerId() : source.getControllerId(), this.chooseTargets, this.amount, this.applier);
            return true;
        }
        return false;
    }

    @Override
    public CopyTargetStackObjectEffect copy() {
        return new CopyTargetStackObjectEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        String amountText;
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        String string = this.amount == 1 ? "" : (amountText = this.amount == 2 ? " twice" : " " + CardUtil.numberToText(this.amount) + " times");
        String chooseText = this.chooseTargets ? ". You may choose new targets for the cop" + (this.amount == 1 ? "y" : "ies") : "";
        return "copy " + this.getTargetPointer().describeTargets(mode.getTargets(), this.objectName) + amountText + chooseText;
    }
}

