/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.util.CardUtil;

public class CreateXXTokenExiledEffectManaValueEffect
extends OneShotEffect {
    private final Function<Integer, Token> tokenMaker;

    public CreateXXTokenExiledEffectManaValueEffect(Function<Integer, Token> tokenMaker, String description) {
        super(Outcome.Benefit);
        this.tokenMaker = tokenMaker;
        this.staticText = "the exiled card's owner creates an X/X " + description + " creature token, where X is the mana value of the exiled card";
    }

    private CreateXXTokenExiledEffectManaValueEffect(CreateXXTokenExiledEffectManaValueEffect effect) {
        super(effect);
        this.tokenMaker = effect.tokenMaker;
    }

    @Override
    public CreateXXTokenExiledEffectManaValueEffect copy() {
        return new CreateXXTokenExiledEffectManaValueEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanentLeftBattlefield = (Permanent)this.getValue("permanentLeftBattlefield");
        ExileZone exile = game.getExile().getExileZone(CardUtil.getExileZoneId(game, source.getSourceId(), permanentLeftBattlefield.getZoneChangeCounter(game)));
        if (exile == null || exile.isEmpty()) {
            return false;
        }
        HashSet owners = new HashSet();
        int totalCMC = exile.getCards(game).stream().filter(Objects::nonNull).map(card -> {
            owners.add(card.getOwnerId());
            return card;
        }).mapToInt(MageObject::getManaValue).sum();
        for (UUID playerId : owners) {
            this.tokenMaker.apply(totalCMC).putOntoBattlefield(1, game, source, playerId);
        }
        return true;
    }
}

