/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

public class DamageControllerEffect
extends OneShotEffect {
    protected DynamicValue amount;
    protected boolean preventable;
    private String sourceName = "{this}";

    public DamageControllerEffect(int amount) {
        this(amount, true);
    }

    public DamageControllerEffect(int amount, boolean preventable) {
        this(amount, preventable, "{this}");
    }

    public DamageControllerEffect(int amount, String whoDealDamageName) {
        this(amount, true, whoDealDamageName);
    }

    public DamageControllerEffect(int amount, boolean preventable, String whoDealDamageName) {
        this(StaticValue.get(amount), preventable, whoDealDamageName);
    }

    public DamageControllerEffect(DynamicValue amount) {
        this(amount, "{this}");
    }

    public DamageControllerEffect(DynamicValue amount, String whoDealDamageName) {
        this(amount, true, whoDealDamageName);
    }

    public DamageControllerEffect(DynamicValue amount, boolean preventable, String whoDealDamageName) {
        super(Outcome.Damage);
        this.amount = amount;
        this.preventable = preventable;
        this.sourceName = whoDealDamageName;
    }

    protected DamageControllerEffect(DamageControllerEffect effect) {
        super(effect);
        this.amount = effect.amount;
        this.preventable = effect.preventable;
        this.sourceName = effect.sourceName;
    }

    @Override
    public DamageControllerEffect copy() {
        return new DamageControllerEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.damage(this.amount.calculate(game, source, this), source.getSourceId(), source, game, false, this.preventable);
            return true;
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder();
        String message = this.amount.getMessage();
        sb.append(this.sourceName).append(" deals ");
        if (message.isEmpty() || !message.equals("1")) {
            sb.append(this.amount);
        }
        sb.append(" damage to you");
        if (!message.isEmpty()) {
            if (message.equals("1")) {
                sb.append(" equal to the number of ");
            } else if (message.startsWith("the") || message.startsWith("twice")) {
                sb.append(" equal to ");
            } else {
                sb.append(" for each ");
            }
            sb.append(message);
        }
        if (!this.preventable) {
            sb.append(". The damage can't be prevented");
        }
        return sb.toString();
    }
}

