/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

public class DamageWithPowerFromOneToAnotherTargetEffect
extends OneShotEffect {
    private final String firstTargetName;
    private final int multiplier;

    public DamageWithPowerFromOneToAnotherTargetEffect() {
        this("");
    }

    public DamageWithPowerFromOneToAnotherTargetEffect(String firstTargetName) {
        this(firstTargetName, 1);
    }

    public DamageWithPowerFromOneToAnotherTargetEffect(String firstTargetName, int multiplier) {
        super(Outcome.Damage);
        this.firstTargetName = firstTargetName;
        this.multiplier = multiplier;
    }

    protected DamageWithPowerFromOneToAnotherTargetEffect(DamageWithPowerFromOneToAnotherTargetEffect effect) {
        super(effect);
        this.firstTargetName = effect.firstTargetName;
        this.multiplier = effect.multiplier;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        if (source.getTargets().size() != 2) {
            throw new IllegalStateException("It must have two targets, but found " + source.getTargets().size());
        }
        Permanent myPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (myPermanent == null) {
            return false;
        }
        int damageValue = myPermanent.getPower().getValue() * this.multiplier;
        Permanent anotherPermanent = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        Player anotherPlayer = game.getPlayer(((Target)source.getTargets().get(1)).getFirstTarget());
        if (anotherPermanent != null) {
            anotherPermanent.damage(damageValue, myPermanent.getId(), source, game, false, true);
            return true;
        }
        if (anotherPlayer != null) {
            anotherPlayer.damage(damageValue, myPermanent.getId(), source, game);
            return true;
        }
        return false;
    }

    @Override
    public DamageWithPowerFromOneToAnotherTargetEffect copy() {
        return new DamageWithPowerFromOneToAnotherTargetEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        if (mode.getTargets().size() != 2) {
            throw new IllegalStateException("It must have two targets, but found " + mode.getTargets().size());
        }
        return (this.firstTargetName.isEmpty() ? ((Target)mode.getTargets().get(0)).getDescription() : this.firstTargetName) + " deals damage equal to" + (this.multiplier == 2 ? " twice" : "") + " its power to " + ((Target)mode.getTargets().get(1)).getDescription();
    }
}

