/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class DestroyAllAttachedToTargetEffect
extends OneShotEffect {
    private final FilterPermanent filter;

    public DestroyAllAttachedToTargetEffect(FilterPermanent filter, String description) {
        super(Outcome.DestroyPermanent);
        this.filter = filter;
        this.staticText = "destroy all " + filter.getMessage() + " attached to " + description;
    }

    protected DestroyAllAttachedToTargetEffect(DestroyAllAttachedToTargetEffect effect) {
        super(effect);
        this.filter = effect.filter;
    }

    @Override
    public DestroyAllAttachedToTargetEffect copy() {
        return new DestroyAllAttachedToTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent targetPermanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (targetPermanent != null) {
            ArrayList<UUID> attachments = new ArrayList<UUID>(targetPermanent.getAttachments());
            for (UUID attachmentId : attachments) {
                Permanent attachment = game.getPermanent(attachmentId);
                if (!this.filter.match(attachment, source.getControllerId(), source, game)) continue;
                attachment.destroy(source, game, false);
            }
        }
        return true;
    }
}

