/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.costs.Cost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

public class DoIfAnyNumberCostPaid
extends OneShotEffect {
    private final Effect executingEffect;
    private final Cost cost;

    public DoIfAnyNumberCostPaid(OneShotEffect effect, Cost cost) {
        super(Outcome.Benefit);
        this.executingEffect = effect;
        this.cost = cost;
    }

    private DoIfAnyNumberCostPaid(DoIfAnyNumberCostPaid effect) {
        super(effect);
        this.executingEffect = effect.executingEffect.copy();
        this.cost = effect.cost.copy();
    }

    @Override
    public DoIfAnyNumberCostPaid copy() {
        return new DoIfAnyNumberCostPaid(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        String costText = this.cost.getText();
        int timesPaid = 0;
        while (controller.canRespond()) {
            this.cost.clearPaid();
            if (!this.cost.canPay(source, source, source.getControllerId(), game) || !controller.chooseUse(this.outcome, "Pay " + costText + "? You have paid this cost " + timesPaid + " time" + (timesPaid != 1 ? "s" : ""), source, game) || !this.cost.pay(source, game, source, source.getControllerId(), false)) break;
            ++timesPaid;
        }
        if (timesPaid > 0) {
            this.executingEffect.setValue("timesPaid", timesPaid);
            return this.executingEffect.apply(game, source);
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "you may pay " + this.cost.getText() + " any number of times. When you pay this cost one or more times, " + this.executingEffect.getText(mode);
    }
}

