/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.events.GameEvent;

public class DontUntapInControllersNextUntapStepSourceEffect
extends ContinuousRuleModifyingEffectImpl {
    private int validForTurnNum;

    public DontUntapInControllersNextUntapStepSourceEffect() {
        super(Duration.Custom, Outcome.Detriment, false, true);
        this.staticText = "{this} doesn't untap during your next untap step";
        this.validForTurnNum = 0;
    }

    protected DontUntapInControllersNextUntapStepSourceEffect(DontUntapInControllersNextUntapStepSourceEffect effect) {
        super(effect);
        this.validForTurnNum = effect.validForTurnNum;
    }

    @Override
    public DontUntapInControllersNextUntapStepSourceEffect copy() {
        return new DontUntapInControllersNextUntapStepSourceEffect(this);
    }

    @Override
    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "{this} doesn't untap (" + mageObject.getLogName() + ')';
        }
        return null;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNTAP_STEP || event.getType() == GameEvent.EventType.UNTAP;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        if (this.validForTurnNum > 0 && this.validForTurnNum < game.getTurnNum()) {
            this.discard();
            return false;
        }
        if (event.getType() == GameEvent.EventType.UNTAP_STEP && game.isActivePlayer(source.getControllerId())) {
            if (this.validForTurnNum == game.getTurnNum()) {
                this.discard();
                return false;
            }
            this.validForTurnNum = game.getTurnNum();
        }
        if (game.getTurnStepType() == PhaseStep.UNTAP && event.getType() == GameEvent.EventType.UNTAP && game.isActivePlayer(source.getControllerId()) && event.getTargetId().equals(source.getSourceId())) {
            this.discard();
            return true;
        }
        return false;
    }
}

