/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetOpponent;
import mage.target.targetpointer.FixedTarget;

public class EntersBattlefieldUnderControlOfOpponentOfChoiceEffect
extends OneShotEffect {
    public EntersBattlefieldUnderControlOfOpponentOfChoiceEffect() {
        super(Outcome.Benefit);
        this.staticText = "under the control of an opponent of your choice";
    }

    private EntersBattlefieldUnderControlOfOpponentOfChoiceEffect(EntersBattlefieldUnderControlOfOpponentOfChoiceEffect effect) {
        super(effect);
    }

    @Override
    public EntersBattlefieldUnderControlOfOpponentOfChoiceEffect copy() {
        return new EntersBattlefieldUnderControlOfOpponentOfChoiceEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetOpponent target = new TargetOpponent();
        target.withNotTarget(true);
        if (!controller.choose(Outcome.Benefit, target, source, game)) {
            return false;
        }
        Player opponent = game.getPlayer(target.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (permanent != null) {
            permanent.setOriginalControllerId(opponent.getId());
            permanent.setControllerId(opponent.getId());
            game.informPlayers(permanent.getLogName() + " enters the battlefield under the control of " + opponent.getLogName());
        }
        GainControlTargetEffect continuousEffect = new GainControlTargetEffect(Duration.Custom, true, opponent.getId());
        continuousEffect.setTargetPointer(new FixedTarget(source.getSourceId(), source.getStackMomentSourceZCC()));
        game.addEffect(continuousEffect, source);
        return true;
    }
}

