/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.ArrayList;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.AbilityType;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class EntersBattlefieldWithXCountersEffect
extends OneShotEffect {
    protected final Counter counter;
    private final int multiplier;

    public EntersBattlefieldWithXCountersEffect(Counter counter) {
        this(counter, 1);
    }

    public EntersBattlefieldWithXCountersEffect(Counter counter, int multiplier) {
        super(Outcome.BoostCreature);
        this.counter = counter;
        this.multiplier = multiplier;
        String countText = "X";
        if (multiplier == 2) {
            countText = "twice " + countText;
        }
        if (multiplier > 2) {
            countText = CardUtil.numberToText(multiplier) + " times " + countText;
        }
        this.staticText = "with " + countText + " " + counter.getName() + " counters on it";
    }

    protected EntersBattlefieldWithXCountersEffect(EntersBattlefieldWithXCountersEffect effect) {
        super(effect);
        this.counter = effect.counter.copy();
        this.multiplier = effect.multiplier;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        int amount;
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null && source.getAbilityType() == AbilityType.STATIC) {
            permanent = game.getPermanentEntering(source.getSourceId());
        }
        if (permanent != null && (amount = CardUtil.getSourceCostsTag(game, source, "X", 0) * this.multiplier) > 0) {
            Counter counterToAdd = this.counter.copy();
            counterToAdd.add(amount - this.counter.getCount());
            ArrayList appliedEffects = (ArrayList)this.getValue("appliedEffects");
            permanent.addCounters(counterToAdd, source.getControllerId(), source, game, appliedEffects);
        }
        return true;
    }

    @Override
    public EntersBattlefieldWithXCountersEffect copy() {
        return new EntersBattlefieldWithXCountersEffect(this);
    }
}

