/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class EpicReplacementEffect
extends ContinuousRuleModifyingEffectImpl {
    EpicReplacementEffect() {
        super(Duration.EndOfGame, Outcome.Neutral);
        this.staticText = "For the rest of the game, you can't cast spells";
    }

    private EpicReplacementEffect(EpicReplacementEffect effect) {
        super(effect);
    }

    @Override
    public EpicReplacementEffect copy() {
        return new EpicReplacementEffect(this);
    }

    @Override
    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "For the rest of the game, you can't cast spells (Epic - " + mageObject.getName() + ')';
        }
        return null;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId()) && game.getObject(event.getSourceId()) != null;
    }
}

