/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class ExileAndGainLifeEqualPowerTargetEffect
extends OneShotEffect {
    public ExileAndGainLifeEqualPowerTargetEffect() {
        super(Outcome.Removal);
        this.staticText = "Exile target creature. Its controller gains life equal to its power";
    }

    private ExileAndGainLifeEqualPowerTargetEffect(ExileAndGainLifeEqualPowerTargetEffect effect) {
        super(effect);
    }

    @Override
    public ExileAndGainLifeEqualPowerTargetEffect copy() {
        return new ExileAndGainLifeEqualPowerTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent == null) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(permanent.getControllerId());
        if (controller == null || player == null) {
            return true;
        }
        int creaturePower = permanent.getPower().getValue();
        controller.moveCards(permanent, Zone.EXILED, source, game);
        player.gainLife(creaturePower, game, source);
        return true;
    }
}

