/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Pronoun;
import mage.constants.PutCards;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class ExileAndReturnSourceEffect
extends OneShotEffect {
    private final Pronoun pronoun;
    private final Effect additionalEffect;
    private final boolean returnUnderYourControl;
    private final PutCards putCards;

    public ExileAndReturnSourceEffect(PutCards putCards) {
        this(putCards, Pronoun.IT);
    }

    public ExileAndReturnSourceEffect(PutCards putCards, Pronoun pronoun) {
        this(putCards, pronoun, false);
    }

    public ExileAndReturnSourceEffect(PutCards putCards, Pronoun pronoun, boolean returnUnderYourControl) {
        this(putCards, pronoun, returnUnderYourControl, null);
    }

    public ExileAndReturnSourceEffect(PutCards putCards, Pronoun pronoun, boolean returnUnderYourControl, Effect additionalEffect) {
        super(Outcome.Benefit);
        this.pronoun = pronoun;
        this.putCards = putCards;
        this.additionalEffect = additionalEffect;
        this.returnUnderYourControl = returnUnderYourControl;
    }

    protected ExileAndReturnSourceEffect(ExileAndReturnSourceEffect effect) {
        super(effect);
        this.putCards = effect.putCards;
        this.pronoun = effect.pronoun;
        this.additionalEffect = effect.additionalEffect;
        this.returnUnderYourControl = effect.returnUnderYourControl;
    }

    @Override
    public ExileAndReturnSourceEffect copy() {
        return new ExileAndReturnSourceEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || controller == null) {
            return true;
        }
        controller.moveCards(permanent, Zone.EXILED, source, game);
        this.putCards.moveCard(this.returnUnderYourControl ? controller : game.getPlayer(permanent.getOwnerId()), permanent.getMainCard(), source, game, "card");
        if (this.additionalEffect == null || game.getPermanent(permanent.getId()) == null) {
            return true;
        }
        if (this.additionalEffect instanceof ContinuousEffect) {
            game.addEffect((ContinuousEffect)this.additionalEffect, source);
        } else {
            this.additionalEffect.apply(game, source);
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "exile {this}, then return " + this.pronoun.getObjective() + ' ' + this.putCards.getMessage(false, false).replace("onto", "to") + " under " + (this.returnUnderYourControl ? "your" : this.pronoun.getPossessive() + " owner's") + " control" + (this.additionalEffect == null ? "" : ". If you do, " + this.additionalEffect.getText(mode));
    }
}

