/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FirstTargetPointer;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

public class ExileTargetForSourceEffect
extends OneShotEffect {
    public ExileTargetForSourceEffect() {
        super(Outcome.Exile);
    }

    protected ExileTargetForSourceEffect(ExileTargetForSourceEffect effect) {
        super(effect);
    }

    @Override
    public ExileTargetForSourceEffect copy() {
        return new ExileTargetForSourceEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        LinkedHashSet<UUID> objectsToMove = new LinkedHashSet<UUID>();
        if (this.getTargetPointer() instanceof FirstTargetPointer && source.getTargets().size() > 1) {
            for (Object target : source.getTargets()) {
                objectsToMove.addAll(target.getTargets());
            }
        } else if (!this.getTargetPointer().getTargets(game, source).isEmpty()) {
            objectsToMove.addAll(this.getTargetPointer().getTargets(game, source));
        } else {
            UUID fixedTargetId = null;
            for (Effect effect : source.getEffects()) {
                TargetPointer targetPointerId = effect.getTargetPointer();
                if (!(targetPointerId instanceof FixedTarget)) continue;
                fixedTargetId = ((FixedTarget)targetPointerId).getTarget();
            }
            if (fixedTargetId != null) {
                objectsToMove.add(fixedTargetId);
            }
        }
        UUID exileId = CardUtil.getExileZoneId(game, source.getSourceId(), source.getStackMomentSourceZCC());
        Set<Card> cardsToMove = objectsToMove.stream().map(game::getObject).filter(Objects::nonNull).map(object -> {
            if (object instanceof Card) {
                return (Card)object;
            }
            return game.getCard(object.getId());
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        return controller.moveCardsToExile(cardsToMove, source, game, true, exileId, sourceObject.getIdName());
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "exile " + this.getTargetPointer().describeTargets(mode.getTargets(), "it");
    }
}

