/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.util.CardUtil;

public class ExileThenReturnTargetEffect
extends OneShotEffect {
    private final boolean yourControl;
    private final boolean textThatCard;
    private final PutCards putCards;
    private OneShotEffect afterEffect = null;

    public ExileThenReturnTargetEffect(boolean yourControl, boolean textThatCard) {
        this(yourControl, textThatCard, PutCards.BATTLEFIELD);
    }

    public ExileThenReturnTargetEffect(boolean yourControl, boolean textThatCard, PutCards putCards) {
        super(Outcome.Benefit);
        this.yourControl = yourControl;
        this.textThatCard = textThatCard;
        this.putCards = putCards;
    }

    protected ExileThenReturnTargetEffect(ExileThenReturnTargetEffect effect) {
        super(effect);
        this.putCards = effect.putCards;
        this.yourControl = effect.yourControl;
        this.textThatCard = effect.textThatCard;
        this.afterEffect = effect.afterEffect == null ? null : effect.afterEffect.copy();
    }

    @Override
    public ExileThenReturnTargetEffect copy() {
        return new ExileThenReturnTargetEffect(this);
    }

    public ExileThenReturnTargetEffect withAfterEffect(OneShotEffect afterEffect) {
        this.afterEffect = afterEffect;
        return this;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Set toFlicker = this.getTargetPointer().getTargets(game, source).stream().map(game::getPermanent).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        if (toFlicker.isEmpty()) {
            return false;
        }
        controller.moveCards(toFlicker, Zone.EXILED, source, game);
        game.processAction();
        for (Card card : toFlicker) {
            this.putCards.moveCard(this.yourControl ? controller : game.getPlayer(card.getOwnerId()), card.getMainCard(), source, game, "card");
        }
        if (this.afterEffect != null) {
            this.afterEffect.setTargetPointer(new FixedTargets(toFlicker, game));
            this.afterEffect.apply(game, source);
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder("exile ");
        sb.append(this.getTargetPointer().describeTargets(mode.getTargets(), "that permanent"));
        sb.append(", then return ");
        if (this.getTargetPointer().isPlural(mode.getTargets())) {
            sb.append(this.textThatCard ? "those cards " : "them ");
            sb.append(this.putCards.getMessage(false, false).replace("onto", "to"));
            sb.append(" under ");
            sb.append(this.yourControl ? "your" : "their owner's");
        } else {
            sb.append(this.textThatCard ? "that card " : "it ");
            sb.append(this.putCards.getMessage(false, false).replace("onto", "to"));
            sb.append(" under ");
            sb.append(this.yourControl ? "your" : "its owner's");
        }
        sb.append(" control");
        if (this.afterEffect != null) {
            sb.append(". ").append(CardUtil.getTextWithFirstCharUpperCase(this.afterEffect.getText(mode)));
        }
        return sb.toString();
    }
}

