/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;

class ExileTopCardPlayEffect
extends AsThoughEffectImpl {
    private final UUID exileId;

    ExileTopCardPlayEffect(UUID exileId) {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.Custom, Outcome.Benefit);
        this.exileId = exileId;
    }

    private ExileTopCardPlayEffect(ExileTopCardPlayEffect effect) {
        super(effect);
        this.exileId = effect.exileId;
    }

    @Override
    public ExileTopCardPlayEffect copy() {
        return new ExileTopCardPlayEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return false;
    }

    @Override
    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        Card mainTargetCard = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (mainTargetCard == null) {
            this.discard();
            return false;
        }
        ExileZone exileZone = game.getExile().getExileZone(this.exileId);
        if (exileZone == null || !exileZone.contains(mainTargetCard.getId())) {
            this.discard();
            return false;
        }
        Card objectCard = game.getCard(sourceId);
        if (objectCard == null) {
            return false;
        }
        return mainTargetCard.getId().equals(objectCard.getMainCard().getId()) && affectedControllerId.equals(source.getControllerId());
    }
}

