/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.command.Emblem;
import mage.players.Player;

public class GetEmblemTargetPlayerEffect
extends OneShotEffect {
    private final Emblem emblem;

    public GetEmblemTargetPlayerEffect(Emblem emblem) {
        super(Outcome.Benefit);
        this.emblem = emblem;
    }

    protected GetEmblemTargetPlayerEffect(GetEmblemTargetPlayerEffect effect) {
        super(effect);
        this.emblem = effect.emblem;
    }

    @Override
    public GetEmblemTargetPlayerEffect copy() {
        return new GetEmblemTargetPlayerEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = game.getObject(source);
        if (sourceObject == null) {
            return false;
        }
        Player toPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (toPlayer == null) {
            return false;
        }
        game.addEmblem(this.emblem, sourceObject, toPlayer.getId());
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return this.getTargetPointer().describeTargets(mode.getTargets(), "that player") + " gets an emblem with \"" + String.join((CharSequence)"; ", this.emblem.getAbilities().getRules()) + "\"";
    }
}

