/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.List;
import java.util.UUID;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

public class HideawayPlayEffect
extends OneShotEffect {
    private final boolean playOne;

    public HideawayPlayEffect() {
        this(false);
    }

    public HideawayPlayEffect(boolean playOne) {
        super(Outcome.Benefit);
        this.playOne = playOne;
        this.staticText = playOne ? "if there are cards exiled with it, you may play one of them without paying its mana cost" : "you may play the exiled card without paying its mana cost";
    }

    protected HideawayPlayEffect(HideawayPlayEffect effect) {
        super(effect);
        this.playOne = effect.playOne;
    }

    @Override
    public HideawayPlayEffect copy() {
        return new HideawayPlayEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        ExileZone zone = game.getExile().getExileZone(CardUtil.getExileZoneId(game, source));
        if (controller == null || zone == null || zone.isEmpty()) {
            return true;
        }
        CardsImpl cards = new CardsImpl(zone.getCards(game));
        boolean cardPlayed = false;
        int maxChoices = this.playOne ? 1 : cards.size();
        TargetCard target = new TargetCard(0, maxChoices, Zone.EXILED, new FilterCard("cards to play (in order they're chosen)"));
        controller.choose(Outcome.PlayForFree, cards, target, source, game);
        List<UUID> targets = target.getTargets();
        for (UUID targetId : targets) {
            UUID playerId;
            Card card = game.getCard(targetId);
            if (card.isLand(game) && (!game.isActivePlayer(playerId = controller.getId()) || !game.getPlayer(playerId).canPlayLand())) continue;
            card.setFaceDown(false, game);
            int zcc = card.getZoneChangeCounter(game);
            if (controller.playCard(card, game, true, new ApprovingObject(source, game))) {
                cardPlayed = true;
                continue;
            }
            if (card.getZoneChangeCounter(game) != zcc) continue;
            card.setFaceDown(true, game);
        }
        return cardPlayed;
    }
}

