/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.hint.Hint;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

public class InfoEffect
extends OneShotEffect {
    public InfoEffect(String text) {
        super(Outcome.Neutral);
        this.staticText = text;
    }

    protected InfoEffect(InfoEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return true;
    }

    @Override
    public InfoEffect copy() {
        return new InfoEffect(this);
    }

    public static void addInfoToPermanent(Game game, Ability source, Permanent permanent, String info) {
        InfoEffect.addInfoToPermanent(game, source, permanent, info, Duration.WhileOnBattlefield);
    }

    public static void addInfoToPermanent(Game game, Ability source, Permanent permanent, String info, Duration duration) {
        SimpleStaticAbility ability = new SimpleStaticAbility(new InfoEffect(info));
        GainAbilityTargetEffect gainEffect = new GainAbilityTargetEffect(ability, duration);
        gainEffect.setTargetPointer(new FixedTarget(permanent, game));
        game.addEffect(gainEffect, source);
    }

    public static void addCardHintToPermanent(Game game, Ability source, Permanent permanent, Hint cardHint, Duration duration) {
        SimpleStaticAbility ability = new SimpleStaticAbility(new InfoEffect("hint"));
        ability.setRuleVisible(false);
        ability.addHint(cardHint);
        GainAbilityTargetEffect gainEffect = new GainAbilityTargetEffect(ability, duration);
        gainEffect.setTargetPointer(new FixedTarget(permanent, game));
        game.addEffect(gainEffect, source);
    }

    public static void addCardHintToPermanentConditional(Game game, Ability source, Permanent permanent, Hint cardHint, Duration duration, Condition condition) {
        SimpleStaticAbility ability = new SimpleStaticAbility(new InfoEffect("hint"));
        ability.setRuleVisible(false);
        ability.addHint(cardHint);
        GainAbilityTargetEffect gainEffect = new GainAbilityTargetEffect(ability, duration);
        gainEffect.setTargetPointer(new FixedTarget(permanent, game));
        ConditionalContinuousEffect conditionalEffect = new ConditionalContinuousEffect(gainEffect, condition, "test");
        conditionalEffect.setTargetPointer(new FixedTarget(permanent, game));
        game.addEffect(conditionalEffect, source);
    }
}

