/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.LookLibraryControllerEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.PutCards;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

public class LookLibraryAndPickControllerEffect
extends LookLibraryControllerEffect {
    protected int numberToPick;
    protected PutCards putPickedCards;
    protected FilterCard filter;
    protected boolean revealPickedCards;
    protected boolean optional;
    protected boolean upTo;
    protected Effect otherwiseEffect = null;

    public LookLibraryAndPickControllerEffect(int numberOfCards, int numberToPick, PutCards putPickedCards, PutCards putLookedCards) {
        this(numberOfCards, numberToPick, putPickedCards, putLookedCards, false);
    }

    public LookLibraryAndPickControllerEffect(DynamicValue numberOfCards, int numberToPick, PutCards putPickedCards, PutCards putLookedCards) {
        this(numberOfCards, numberToPick, putPickedCards, putLookedCards, false);
    }

    public LookLibraryAndPickControllerEffect(int numberOfCards, int numberToPick, PutCards putPickedCards, PutCards putLookedCards, boolean upTo) {
        this((DynamicValue)StaticValue.get(numberOfCards), numberToPick, putPickedCards, putLookedCards, upTo);
    }

    public LookLibraryAndPickControllerEffect(DynamicValue numberOfCards, int numberToPick, PutCards putPickedCards, PutCards putLookedCards, boolean upTo) {
        super(putPickedCards.getOutcome(), numberOfCards, putLookedCards);
        this.numberToPick = numberToPick;
        this.putPickedCards = putPickedCards;
        this.filter = numberToPick > 1 ? StaticFilters.FILTER_CARD_CARDS : StaticFilters.FILTER_CARD_A;
        this.revealPickedCards = false;
        this.optional = false;
        this.upTo = upTo || numberToPick == Integer.MAX_VALUE;
    }

    public LookLibraryAndPickControllerEffect(int numberOfCards, int numberToPick, FilterCard filter, PutCards putPickedCards, PutCards putLookedCards) {
        this(numberOfCards, numberToPick, filter, putPickedCards, putLookedCards, true);
    }

    public LookLibraryAndPickControllerEffect(DynamicValue numberOfCards, int numberToPick, FilterCard filter, PutCards putPickedCards, PutCards putLookedCards) {
        this(numberOfCards, numberToPick, filter, putPickedCards, putLookedCards, true);
    }

    public LookLibraryAndPickControllerEffect(int numberOfCards, int numberToPick, FilterCard filter, PutCards putPickedCards, PutCards putLookedCards, boolean optional) {
        this(StaticValue.get(numberOfCards), numberToPick, filter, putPickedCards, putLookedCards, optional);
    }

    public LookLibraryAndPickControllerEffect(DynamicValue numberOfCards, int numberToPick, FilterCard filter, PutCards putPickedCards, PutCards putLookedCards, boolean optional) {
        super(putPickedCards.getOutcome(), numberOfCards, putLookedCards);
        this.numberToPick = numberToPick;
        this.putPickedCards = putPickedCards;
        this.filter = filter;
        this.revealPickedCards = !putPickedCards.getZone().isPublicZone();
        this.optional = optional;
        this.upTo = numberToPick > 1;
    }

    protected LookLibraryAndPickControllerEffect(LookLibraryAndPickControllerEffect effect) {
        super(effect);
        this.numberToPick = effect.numberToPick;
        this.putPickedCards = effect.putPickedCards;
        this.filter = effect.filter.copy();
        this.revealPickedCards = effect.revealPickedCards;
        this.optional = effect.optional;
        this.upTo = effect.upTo;
        this.otherwiseEffect = effect.otherwiseEffect != null ? effect.otherwiseEffect.copy() : null;
    }

    @Override
    public LookLibraryAndPickControllerEffect copy() {
        return new LookLibraryAndPickControllerEffect(this);
    }

    public LookLibraryAndPickControllerEffect withOtherwiseEffect(Effect otherwiseEffect) {
        this.otherwiseEffect = otherwiseEffect;
        return this;
    }

    @Override
    protected boolean actionWithLookedCards(Game game, Ability source, Player player, Cards cards) {
        int number = Math.min(this.numberToPick, cards.count(this.filter, source.getControllerId(), source, game));
        if (number < 1 || this.optional && !player.chooseUse(this.putPickedCards.getOutcome(), this.getMayText(), source, game)) {
            return this.actionWithPickedCards(game, source, player, new CardsImpl(), cards);
        }
        TargetCard target = new TargetCard(this.upTo ? 0 : number, number, Zone.LIBRARY, this.filter);
        target.withChooseHint(this.getChooseHint());
        if (!player.chooseTarget(this.putPickedCards.getOutcome(), cards, target, source, game)) {
            return this.actionWithPickedCards(game, source, player, new CardsImpl(), cards);
        }
        CardsImpl pickedCards = new CardsImpl((Collection<UUID>)target.getTargets());
        if (this.revealPickedCards) {
            player.revealCards(source, (Cards)pickedCards, game);
        }
        cards.removeAll(pickedCards);
        return this.actionWithPickedCards(game, source, player, pickedCards, cards);
    }

    protected boolean actionWithPickedCards(Game game, Ability source, Player player, Cards pickedCards, Cards otherCards) {
        boolean result = this.putPickedCards.moveCards(player, pickedCards, source, game);
        result |= this.putLookedCards.moveCards(player, otherCards, source, game);
        if (!pickedCards.isEmpty() || this.otherwiseEffect == null) {
            return result;
        }
        game.processAction();
        if (this.otherwiseEffect instanceof OneShotEffect) {
            this.otherwiseEffect.apply(game, source);
        } else if (this.otherwiseEffect instanceof ContinuousEffect) {
            game.addEffect((ContinuousEffect)this.otherwiseEffect, source);
        }
        return result;
    }

    protected String getMayText() {
        boolean plural = this.numberToPick > 1;
        StringBuilder sb = new StringBuilder(this.revealPickedCards ? "Reveal " : "Put ");
        sb.append(plural ? this.filter.getMessage() : CardUtil.addArticle(this.filter.getMessage()));
        if (this.revealPickedCards) {
            sb.append(" and put ");
            sb.append(plural ? "them" : "it");
        }
        sb.append(" ");
        sb.append(this.putPickedCards.getMessage(false, plural));
        return sb.append("?").toString();
    }

    protected String getChooseHint() {
        return "to put " + this.putPickedCards.getMessage(false, this.numberToPick > 1);
    }

    @Override
    public String getText(Mode mode) {
        boolean plural;
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder(". ");
        if (this.optional) {
            sb.append(this.revealPickedCards ? "You may reveal " : "You may put ");
        } else {
            sb.append(this.revealPickedCards ? "Reveal " : "Put ");
        }
        boolean havePredicates = this.filter.hasPredicates();
        boolean bl = plural = this.numberToPick > 1;
        if (havePredicates && !plural && !this.upTo) {
            sb.append(CardUtil.addArticle(this.filter.getMessage()));
        } else if (this.numberToPick == Integer.MAX_VALUE) {
            sb.append("any number of ");
            if (havePredicates) {
                sb.append(this.filter.getMessage());
            }
        } else {
            if (this.upTo) {
                sb.append("up to ");
            }
            sb.append(CardUtil.numberToText(this.numberToPick));
            sb.append(" ");
            sb.append(havePredicates ? this.filter.getMessage() : "of ");
        }
        if (havePredicates) {
            sb.append(" from among ");
        }
        sb.append("them ");
        if (this.revealPickedCards) {
            sb.append("and put ");
            sb.append(plural ? "them " : "it ");
        } else if (this.putPickedCards == PutCards.TOP_ANY && this.numberOfCards instanceof StaticValue) {
            sb.append("back ");
        }
        sb.append(this.putPickedCards.getMessage(false, plural));
        boolean bl2 = plural = this.optional || this.upTo || !(this.numberOfCards instanceof StaticValue) || this.numberOfCards.calculate(null, null, this) - this.numberToPick != 1;
        if (!plural && this.putLookedCards == PutCards.TOP_ANY) {
            return this.setText(mode, sb.toString());
        }
        sb.append(havePredicates && (this.optional || this.upTo) ? ". Put" : " and");
        sb.append(" the ");
        sb.append(plural ? "rest " : "other ");
        if (this.putPickedCards == PutCards.GRAVEYARD && this.putLookedCards == PutCards.TOP_ANY) {
            sb.append("back ");
        }
        sb.append(this.putLookedCards.getMessage(false, plural));
        if (this.otherwiseEffect != null) {
            sb.append(". If you didn't put a card ");
            sb.append(this.putPickedCards.getMessage(false, false));
            sb.append(" this way, ");
            sb.append(this.otherwiseEffect.getText(mode));
        }
        return this.setText(mode, sb.toString());
    }
}

