/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

public class LoseLifeDefendingPlayerEffect
extends OneShotEffect {
    private DynamicValue amount;
    private boolean attackerIsSource;

    public LoseLifeDefendingPlayerEffect(int amount, boolean attackerIsSource) {
        this(StaticValue.get(amount), attackerIsSource);
    }

    public LoseLifeDefendingPlayerEffect(DynamicValue amount, boolean attackerIsSource) {
        super(Outcome.Damage);
        this.amount = amount;
        this.attackerIsSource = attackerIsSource;
    }

    protected LoseLifeDefendingPlayerEffect(LoseLifeDefendingPlayerEffect effect) {
        super(effect);
        this.amount = effect.amount.copy();
        this.attackerIsSource = effect.attackerIsSource;
    }

    @Override
    public LoseLifeDefendingPlayerEffect copy() {
        return new LoseLifeDefendingPlayerEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player defender = this.attackerIsSource ? game.getPlayer(game.getCombat().getDefendingPlayerId(source.getSourceId(), game)) : game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (defender != null) {
            defender.loseLife(this.amount.calculate(game, source, this), game, source, false);
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        return "defending player loses " + this.amount + " life";
    }
}

