/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class MayTapOrUntapTargetEffect
extends OneShotEffect {
    public MayTapOrUntapTargetEffect() {
        super(Outcome.AIDontUseIt);
    }

    protected MayTapOrUntapTargetEffect(MayTapOrUntapTargetEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Player player = game.getPlayer(source.getControllerId());
        if (target != null && player != null) {
            if (target.isTapped()) {
                if (player.chooseUse(Outcome.Untap, "Untap that permanent?", source, game)) {
                    target.untap(game);
                }
            } else if (player.chooseUse(Outcome.Tap, "Tap that permanent?", source, game)) {
                target.tap(source, game);
            }
            return true;
        }
        return false;
    }

    @Override
    public MayTapOrUntapTargetEffect copy() {
        return new MayTapOrUntapTargetEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "you may tap or untap " + this.getTargetPointer().describeTargets(mode.getTargets(), "it");
    }
}

