/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

public class MillHalfLibraryTargetEffect
extends OneShotEffect {
    private final boolean roundUp;

    public MillHalfLibraryTargetEffect(boolean roundUp) {
        super(Outcome.Benefit);
        this.roundUp = roundUp;
    }

    private MillHalfLibraryTargetEffect(MillHalfLibraryTargetEffect effect) {
        super(effect);
        this.roundUp = effect.roundUp;
    }

    @Override
    public MillHalfLibraryTargetEffect copy() {
        return new MillHalfLibraryTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (UUID playerId : this.getTargetPointer().getTargets(game, source)) {
            Player player = game.getPlayer(playerId);
            if (player == null) {
                return false;
            }
            int count = player.getLibrary().size();
            player.millCards(count / 2 + (this.roundUp ? count % 2 : 0), source, game);
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return this.getTargetPointer().describeTargets(mode.getTargets(), "that player") + " mills half their library, rounded " + (this.roundUp ? "up" : "down");
    }
}

