/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

public class MillThenPutInHandEffect
extends OneShotEffect {
    private final DynamicValue amount;
    private final boolean optional;
    private final int maxAmountReturned;
    private final FilterCard filter;
    private final Effect otherwiseEffect;
    private String textFromAmong = "the milled cards";

    public MillThenPutInHandEffect(int amount, FilterCard filter) {
        this(amount, filter, true);
    }

    public MillThenPutInHandEffect(int amount, FilterCard filter, boolean optional) {
        this(amount, filter, null, optional);
    }

    public MillThenPutInHandEffect(int amount, FilterCard filter, Effect otherwiseEffect) {
        this(amount, filter, otherwiseEffect, true);
        this.textFromAmong = "the cards milled this way";
    }

    public MillThenPutInHandEffect(int amount, FilterCard filter, Effect otherwiseEffect, boolean optional) {
        this(amount, filter, otherwiseEffect, optional, 1);
    }

    public MillThenPutInHandEffect(int amount, FilterCard filter, Effect otherwiseEffect, boolean optional, int maxReturnedCard) {
        this(StaticValue.get(amount), filter, otherwiseEffect, optional, maxReturnedCard);
    }

    public MillThenPutInHandEffect(DynamicValue amount, FilterCard filter) {
        this(amount, filter, true);
    }

    public MillThenPutInHandEffect(DynamicValue amount, FilterCard filter, boolean optional) {
        this(amount, filter, null, optional);
    }

    public MillThenPutInHandEffect(DynamicValue amount, FilterCard filter, Effect otherwiseEffect, boolean optional) {
        this(amount, filter, otherwiseEffect, optional, 1);
    }

    public MillThenPutInHandEffect(DynamicValue amount, FilterCard filter, Effect otherwiseEffect, boolean optional, int maxReturnedCard) {
        super(Outcome.Benefit);
        this.amount = amount;
        this.filter = filter;
        this.optional = optional;
        this.maxAmountReturned = maxReturnedCard;
        this.otherwiseEffect = otherwiseEffect;
    }

    private MillThenPutInHandEffect(MillThenPutInHandEffect effect) {
        super(effect);
        this.amount = effect.amount;
        this.optional = effect.optional;
        this.filter = effect.filter;
        this.maxAmountReturned = effect.maxAmountReturned;
        this.otherwiseEffect = effect.otherwiseEffect;
        this.textFromAmong = effect.textFromAmong;
    }

    @Override
    public MillThenPutInHandEffect copy() {
        return new MillThenPutInHandEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int toMill = this.amount.calculate(game, source, this);
        Cards cards = player.millCards(toMill, source, game);
        if (cards.isEmpty()) {
            return this.applyOtherwiseEffect(game, source);
        }
        TargetCard target = new TargetCard(this.optional ? 0 : this.maxAmountReturned, this.maxAmountReturned, Zone.ALL, this.filter);
        player.choose(Outcome.DrawCard, cards, target, source, game);
        Set returned = target.getTargets().stream().map(game::getCard).filter(Objects::nonNull).collect(Collectors.toSet());
        if (returned.isEmpty()) {
            return this.applyOtherwiseEffect(game, source);
        }
        return player.moveCards(returned, Zone.HAND, source, game);
    }

    private boolean applyOtherwiseEffect(Game game, Ability source) {
        if (this.otherwiseEffect instanceof OneShotEffect) {
            return this.otherwiseEffect.apply(game, source);
        }
        if (this.otherwiseEffect instanceof ContinuousEffect) {
            game.addEffect((ContinuousEffect)this.otherwiseEffect, source);
            return true;
        }
        return false;
    }

    public MillThenPutInHandEffect withTextOptions(String fromAmong) {
        this.textFromAmong = fromAmong;
        return this;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder("mill ");
        String value = this.amount.toString();
        sb.append(CardUtil.numberToText(value, "a"));
        sb.append(value.equals("1") ? " card. " : " cards. ");
        if (this.optional) {
            sb.append("You may put ");
        } else {
            sb.append(this.otherwiseEffect == null ? "Then put " : "Put ");
        }
        if (this.maxAmountReturned > 1) {
            sb.append(this.optional ? "up to " : "");
            sb.append(CardUtil.numberToText(this.maxAmountReturned)).append(" ");
            sb.append(this.filter.getMessage());
        } else {
            sb.append(CardUtil.addArticle(this.filter.getMessage()));
        }
        sb.append(" from among ");
        sb.append(this.textFromAmong);
        sb.append(" into your hand");
        if (this.otherwiseEffect != null) {
            sb.append(". If you ");
            sb.append(this.optional ? "don't" : "can't");
            sb.append(", ");
            sb.append(this.otherwiseEffect.getText(mode));
        }
        return sb.toString();
    }
}

