/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class PhaseOutAllEffect
extends OneShotEffect {
    private final List<UUID> idList;

    public PhaseOutAllEffect(List<UUID> idList) {
        super(Outcome.Neutral);
        this.idList = idList;
    }

    protected PhaseOutAllEffect(PhaseOutAllEffect effect) {
        super(effect);
        this.idList = effect.idList;
    }

    @Override
    public PhaseOutAllEffect copy() {
        return new PhaseOutAllEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        for (UUID permanentId : this.idList) {
            Permanent attachedTo;
            permanent = game.getPermanent(permanentId);
            if (permanent == null || (attachedTo = game.getPermanent(permanent.getAttachedTo())) != null) continue;
            permanent.phaseOut(game);
        }
        for (UUID permanentId : this.idList) {
            permanent = game.getPermanent(permanentId);
            if (permanent == null || !permanent.isPhasedIn()) continue;
            permanent.phaseOut(game);
        }
        return true;
    }
}

