/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Planes;
import mage.game.Game;
import mage.game.command.CommandObject;
import mage.game.command.Plane;
import mage.players.Player;

public class PlaneswalkEffect
extends OneShotEffect {
    private final boolean optional;

    public PlaneswalkEffect(boolean optional) {
        super(Outcome.Neutral);
        this.optional = optional;
        this.staticText = optional ? "you may planeswalk" : "you planeswalk";
    }

    protected PlaneswalkEffect(PlaneswalkEffect effect) {
        super(effect);
        this.optional = effect.optional;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        boolean canPlaneswalk = game.getState().getCommand().stream().anyMatch(obj -> obj instanceof Plane);
        if (!canPlaneswalk) {
            return true;
        }
        if (this.optional && !controller.chooseUse(this.outcome, "Planeswalk?", source, game)) {
            return true;
        }
        for (CommandObject cobject : game.getState().getCommand()) {
            if (!(cobject instanceof Plane)) continue;
            if (cobject.getAbilities() != null) {
                for (Ability ability : cobject.getAbilities()) {
                    for (Effect effect : ability.getEffects()) {
                        if (!(effect instanceof ContinuousEffect)) continue;
                        ((ContinuousEffect)effect).discard();
                    }
                }
            }
            game.getState().removeTriggersOfSourceId(cobject.getId());
            game.getState().getCommand().remove(cobject);
            break;
        }
        List<String> planesVisited = game.getState().getSeenPlanes();
        if (game.getState().getSeenPlanes() != null && planesVisited.size() == Planes.values().length) {
            game.getState().resetSeenPlanes();
        }
        boolean foundNextPlane = false;
        while (!foundNextPlane) {
            Plane plane = Plane.createRandomPlane();
            try {
                if (plane == null || planesVisited.contains(plane.getName())) continue;
                foundNextPlane = true;
                game.addPlane(plane, controller.getId());
            }
            catch (Exception exception) {}
        }
        return true;
    }

    @Override
    public PlaneswalkEffect copy() {
        return new PlaneswalkEffect(this);
    }
}

