/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

public class PreventAllDamageByAttachedEffect
extends PreventionEffectImpl {
    private final String attachedDescription;

    public PreventAllDamageByAttachedEffect(Duration duration, String attachedDescription, boolean onlyCombat) {
        super(duration, Integer.MAX_VALUE, onlyCombat, false);
        this.attachedDescription = attachedDescription;
        this.staticText = this.setText();
    }

    protected PreventAllDamageByAttachedEffect(PreventAllDamageByAttachedEffect effect) {
        super(effect);
        this.attachedDescription = effect.attachedDescription;
    }

    @Override
    public PreventAllDamageByAttachedEffect copy() {
        return new PreventAllDamageByAttachedEffect(this);
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent attachment;
        return super.applies(event, source, game) && (attachment = game.getPermanent(source.getSourceId())) != null && attachment.getAttachedTo() != null && event.getSourceId().equals(attachment.getAttachedTo());
    }

    private String setText() {
        StringBuilder sb = new StringBuilder("prevent all ");
        if (this.onlyCombat) {
            sb.append("combat ");
        }
        sb.append("damage that would be dealt by ");
        sb.append(this.attachedDescription);
        return sb.toString();
    }
}

