/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.util.RandomUtil;

public class PutRandomCardFromLibraryIntoGraveyardEffect
extends OneShotEffect {
    private FilterCard filter;

    public PutRandomCardFromLibraryIntoGraveyardEffect(FilterCard filter) {
        super(Outcome.Discard);
        this.filter = filter;
        this.staticText = "put a random " + filter.getMessage() + " from your library into your graveyard";
    }

    private PutRandomCardFromLibraryIntoGraveyardEffect(PutRandomCardFromLibraryIntoGraveyardEffect effect) {
        super(effect);
        this.filter = effect.filter;
    }

    @Override
    public PutRandomCardFromLibraryIntoGraveyardEffect copy() {
        return new PutRandomCardFromLibraryIntoGraveyardEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Set cards = controller.getLibrary().getCards(game).stream().filter(card -> this.filter.match((Card)card, this.getId(), source, game)).collect(Collectors.toSet());
        Card card2 = (Card)RandomUtil.randomFromCollection(cards);
        if (card2 == null) {
            return false;
        }
        game.informPlayers(controller.getLogName() + " puts a random " + this.filter.getMessage() + " from their library into their graveyard.");
        controller.moveCards(card2, Zone.GRAVEYARD, source, game);
        return true;
    }
}

