/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.effects.common.RegenerationShieldsHint;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class RegenerateSourceEffect
extends ReplacementEffectImpl {
    public RegenerateSourceEffect() {
        this("{this}");
    }

    public RegenerateSourceEffect(String targetName) {
        super(Duration.EndOfTurn, Outcome.Regenerate);
        this.staticText = "regenerate " + targetName;
    }

    protected RegenerateSourceEffect(RegenerateSourceEffect effect) {
        super(effect);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        RegenerateSourceEffect.initRegenerationShieldInfo(game, source, source.getSourceId());
    }

    @Override
    public RegenerateSourceEffect copy() {
        return new RegenerateSourceEffect(this);
    }

    @Override
    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null && permanent.regenerate(source, game)) {
            this.used = true;
            this.discard();
            return true;
        }
        return false;
    }

    @Override
    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DESTROY_PERMANENT || event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && event.getTargetId() == source.getSourceId()) {
            this.discard();
            return false;
        }
        return event.getAmount() == 0 && event.getTargetId().equals(source.getSourceId()) && !this.used;
    }

    public static void initRegenerationShieldInfo(Game game, Ability source, UUID permanentId) {
        Permanent permanent = game.getPermanent(permanentId);
        if (permanent != null) {
            RegenerateSourceEffect.incRegenerationShieldsAmount(game, permanent.getId());
            InfoEffect.addCardHintToPermanent(game, source, permanent, RegenerationShieldsHint.instance, Duration.EndOfTurn);
        }
    }

    public static int getRegenerationShieldsAmount(Game game, UUID permanentId) {
        Integer amount = (Integer)game.getState().getValue(CardUtil.getCardZoneString("RegenerationShieldsAmount_turn" + game.getTurnNum(), permanentId, game));
        if (amount != null) {
            return amount;
        }
        return 0;
    }

    private static void setRegenerationShieldsAmount(Game game, UUID permanentId, int amount) {
        game.getState().setValue(CardUtil.getCardZoneString("RegenerationShieldsAmount_turn" + game.getTurnNum(), permanentId, game), amount);
    }

    public static int incRegenerationShieldsAmount(Game game, UUID permanentId) {
        int amount = RegenerateSourceEffect.getRegenerationShieldsAmount(game, permanentId) + 1;
        RegenerateSourceEffect.setRegenerationShieldsAmount(game, permanentId, amount);
        return amount;
    }

    public static int decRegenerationShieldsAmount(Game game, UUID permanentId) {
        int amount = Math.max(0, RegenerateSourceEffect.getRegenerationShieldsAmount(game, permanentId) - 1);
        RegenerateSourceEffect.setRegenerationShieldsAmount(game, permanentId, amount);
        return amount;
    }
}

