/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.cards.MeldCard;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class ReturnToBattlefieldUnderYourControlTargetEffect
extends OneShotEffect {
    private boolean returnFromExileZoneOnly;
    private boolean tapped;

    public ReturnToBattlefieldUnderYourControlTargetEffect() {
        this(false);
    }

    public ReturnToBattlefieldUnderYourControlTargetEffect(boolean returnFromExileZoneOnly) {
        this(returnFromExileZoneOnly, false, "that card");
    }

    public ReturnToBattlefieldUnderYourControlTargetEffect(boolean returnFromExileZoneOnly, boolean tapped) {
        this(returnFromExileZoneOnly, tapped, "that card");
    }

    public ReturnToBattlefieldUnderYourControlTargetEffect(boolean returnFromExileZoneOnly, boolean tapped, String description) {
        super(Outcome.Benefit);
        this.returnFromExileZoneOnly = returnFromExileZoneOnly;
        this.tapped = tapped;
        this.staticText = "return " + description + " to the battlefield " + (tapped ? "tapped " : "") + "under your control";
    }

    protected ReturnToBattlefieldUnderYourControlTargetEffect(ReturnToBattlefieldUnderYourControlTargetEffect effect) {
        super(effect);
        this.returnFromExileZoneOnly = effect.returnFromExileZoneOnly;
        this.tapped = effect.tapped;
    }

    @Override
    public ReturnToBattlefieldUnderYourControlTargetEffect copy() {
        return new ReturnToBattlefieldUnderYourControlTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl cardsToBattlefield = new CardsImpl();
            if (this.returnFromExileZoneOnly) {
                for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                    UUID mainCardId = CardUtil.getMainCardId(game, targetId);
                    if (game.getExile().containsId(mainCardId, game)) {
                        cardsToBattlefield.add(mainCardId);
                        continue;
                    }
                    Card card = game.getCard(targetId);
                    if (!(card instanceof MeldCard)) continue;
                    MeldCard meldCard = (MeldCard)card;
                    Card topCard = meldCard.getTopHalfCard();
                    Card bottomCard = meldCard.getBottomHalfCard();
                    if (topCard.getZoneChangeCounter(game) == meldCard.getTopLastZoneChangeCounter() && game.getExile().containsId(topCard.getId(), game)) {
                        cardsToBattlefield.add(topCard);
                    }
                    if (bottomCard.getZoneChangeCounter(game) != meldCard.getBottomLastZoneChangeCounter() || !game.getExile().containsId(bottomCard.getId(), game)) continue;
                    cardsToBattlefield.add(bottomCard);
                }
            } else {
                cardsToBattlefield.addAll(this.getTargetPointer().getTargets(game, source));
            }
            if (!cardsToBattlefield.isEmpty()) {
                controller.moveCards(cardsToBattlefield.getCards(game), Zone.BATTLEFIELD, source, game, this.tapped, false, false, null);
            }
            return true;
        }
        return false;
    }
}

