/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetControlledPermanent;
import mage.util.CardUtil;

public class ReturnToHandChosenPermanentEffect
extends OneShotEffect {
    protected final FilterControlledPermanent filter;
    protected int number;

    public ReturnToHandChosenPermanentEffect(FilterControlledPermanent filter) {
        this(filter, 1);
    }

    public ReturnToHandChosenPermanentEffect(FilterControlledPermanent filter, int number) {
        super(Outcome.ReturnToHand);
        this.filter = filter;
        this.number = number;
        this.staticText = this.getText();
    }

    protected ReturnToHandChosenPermanentEffect(ReturnToHandChosenPermanentEffect effect) {
        super(effect);
        this.filter = effect.filter;
        this.number = effect.number;
    }

    @Override
    public ReturnToHandChosenPermanentEffect copy() {
        return new ReturnToHandChosenPermanentEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            TargetControlledPermanent target;
            int available = game.getBattlefield().count(this.filter, source.getControllerId(), source, game);
            if (available > 0 && player.chooseTarget(this.outcome, target = new TargetControlledPermanent(Math.min(this.number, available), this.number, this.filter, true), source, game)) {
                player.moveCards(new CardsImpl((Collection<UUID>)target.getTargets()), Zone.HAND, source, game);
            }
            return true;
        }
        return false;
    }

    protected String getText() {
        StringBuilder sb = new StringBuilder("that player returns ");
        if (!this.filter.getMessage().startsWith("another") && !this.filter.getMessage().startsWith("a ")) {
            sb.append(CardUtil.numberToText(this.number, "a")).append(' ');
        }
        sb.append(this.filter.getMessage());
        sb.append(" they control");
        if (this.number > 1) {
            sb.append(" to their owner's hand");
        } else {
            sb.append(" to its owner's hand");
        }
        return sb.toString();
    }
}

