/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetSacrifice;
import mage.util.CardUtil;

public class SacrificeEffect
extends OneShotEffect {
    private final FilterPermanent filter;
    private final String preText;
    private DynamicValue count;

    public SacrificeEffect(FilterPermanent filter, int count, String preText) {
        this(filter, StaticValue.get(count), preText);
    }

    public SacrificeEffect(FilterPermanent filter, DynamicValue count, String preText) {
        super(Outcome.Sacrifice);
        this.filter = filter;
        this.count = count;
        this.preText = preText;
        this.setText();
    }

    protected SacrificeEffect(SacrificeEffect effect) {
        super(effect);
        this.filter = effect.filter;
        this.count = effect.count;
        this.preText = effect.preText;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        boolean applied = false;
        for (UUID playerId : this.getTargetPointer().getTargets(game, source)) {
            TargetSacrifice target;
            int amount;
            Player player = game.getPlayer(playerId);
            if (player == null || (amount = Math.min(this.count.calculate(game, source, this), game.getBattlefield().count(TargetSacrifice.makeFilter(this.filter), player.getId(), source, game))) < 1 || !(target = new TargetSacrifice(amount, this.filter)).choose(Outcome.Sacrifice, player.getId(), source.getSourceId(), source, game)) continue;
            for (UUID targetId : target.getTargets()) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent == null || !permanent.sacrifice(source, game)) continue;
                applied = true;
            }
        }
        return applied;
    }

    public void setAmount(DynamicValue amount) {
        this.count = amount;
    }

    @Override
    public SacrificeEffect copy() {
        return new SacrificeEffect(this);
    }

    private void setText() {
        boolean playerSacs;
        StringBuilder sb = new StringBuilder();
        if (this.preText != null) {
            sb.append(this.preText);
        }
        boolean bl = playerSacs = this.preText != null && (this.preText.endsWith("player") || this.preText.endsWith("opponent") || this.preText.endsWith("controller"));
        if (playerSacs) {
            sb.append(" sacrifices ");
        } else if (this.preText == null || this.preText.isEmpty()) {
            sb.append("sacrifice ");
        } else {
            sb.append(" sacrifice ");
        }
        if (this.count.toString().equals("1")) {
            sb.append(CardUtil.addArticle(this.filter.getMessage()));
        } else {
            sb.append(CardUtil.numberToText(this.count.toString(), "a"));
            sb.append(" ");
            sb.append(this.filter.getMessage());
        }
        if (playerSacs && !this.filter.getMessage().contains("with")) {
            sb.append(" of their choice");
        }
        this.staticText = sb.toString();
    }
}

