/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.combat;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

public class CanBlockAdditionalCreatureAllEffect
extends ContinuousEffectImpl {
    protected int amount;
    protected FilterPermanent filter;

    public CanBlockAdditionalCreatureAllEffect(int amount, FilterPermanent filter, Duration duration) {
        super(duration, Outcome.Benefit);
        this.amount = amount;
        this.filter = filter;
        this.staticText = this.setText();
    }

    protected CanBlockAdditionalCreatureAllEffect(CanBlockAdditionalCreatureAllEffect effect) {
        super(effect);
        this.amount = effect.amount;
        this.filter = effect.filter;
    }

    @Override
    public CanBlockAdditionalCreatureAllEffect copy() {
        return new CanBlockAdditionalCreatureAllEffect(this);
    }

    @Override
    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game)) {
            if (permanent == null) continue;
            if (this.amount > 0) {
                if (permanent.getMaxBlocks() <= 0) continue;
                permanent.setMaxBlocks(permanent.getMaxBlocks() + this.amount);
                continue;
            }
            permanent.setMaxBlocks(0);
        }
        return true;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        return false;
    }

    private String setText() {
        StringBuilder sb = new StringBuilder(this.filter.getMessage());
        sb.append(" can block ");
        switch (this.amount) {
            case 0: {
                sb.append("any number of creatures");
                break;
            }
            case 1: {
                sb.append("an additional creature each combat");
                break;
            }
            default: {
                sb.append(CardUtil.numberToText(this.amount));
                sb.append(" additional creatures");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }
}

