/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.combat;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class CantAttackBlockTargetEffect
extends RestrictionEffect {
    public CantAttackBlockTargetEffect(Duration duration) {
        super(duration);
    }

    protected CantAttackBlockTargetEffect(CantAttackBlockTargetEffect effect) {
        super(effect);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(this.getTargetPointer().getFirst(game, source));
    }

    @Override
    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    @Override
    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    @Override
    public CantAttackBlockTargetEffect copy() {
        return new CantAttackBlockTargetEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        StringBuilder sb = new StringBuilder(this.getTargetPointer().describeTargets(mode.getTargets(), "that creature"));
        sb.append(" can't attack or block ");
        if (this.duration == Duration.EndOfTurn) {
            sb.append("this turn");
        } else {
            sb.append((Object)this.duration);
        }
        return sb.toString();
    }
}

