/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.combat;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class CantAttackTargetEffect
extends RestrictionEffect {
    public CantAttackTargetEffect(Duration duration) {
        super(duration);
    }

    protected CantAttackTargetEffect(CantAttackTargetEffect effect) {
        super(effect);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(this.getTargetPointer().getFirst(game, source));
    }

    @Override
    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    @Override
    public CantAttackTargetEffect copy() {
        return new CantAttackTargetEffect(this);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return this.getTargetPointer().describeTargets(mode.getTargets(), "it") + " can't attack" + (this.duration == Duration.EndOfTurn ? " this turn" : "") + (this.duration == Duration.UntilYourNextTurn ? " until your next turn" : "");
    }
}

