/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.combat;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class CantBeBlockedByCreaturesWithGreaterPowerEffect
extends RestrictionEffect {
    public CantBeBlockedByCreaturesWithGreaterPowerEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Creatures with power greater than {this}'s power can't block it";
    }

    protected CantBeBlockedByCreaturesWithGreaterPowerEffect(CantBeBlockedByCreaturesWithGreaterPowerEffect effect) {
        super(effect);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId());
    }

    @Override
    public boolean canBeBlocked(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return blocker.getPower().getValue() <= attacker.getPower().getValue();
    }

    @Override
    public CantBeBlockedByCreaturesWithGreaterPowerEffect copy() {
        return new CantBeBlockedByCreaturesWithGreaterPowerEffect(this);
    }
}

