/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.combat;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class CantBlockUnlessYouControlSourceEffect
extends RestrictionEffect {
    private final FilterControlledPermanent filter;

    public CantBlockUnlessYouControlSourceEffect(FilterControlledPermanent filter) {
        super(Duration.WhileOnBattlefield);
        this.filter = filter;
        this.staticText = "{this} can't block unless you control " + filter.getMessage();
    }

    protected CantBlockUnlessYouControlSourceEffect(CantBlockUnlessYouControlSourceEffect effect) {
        super(effect);
        this.filter = effect.filter;
    }

    @Override
    public CantBlockUnlessYouControlSourceEffect copy() {
        return new CantBlockUnlessYouControlSourceEffect(this);
    }

    @Override
    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId()) && game.getBattlefield().count(this.filter, source.getControllerId(), source, game) == 0;
    }
}

