/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.combat;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.AbilityType;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.BlockedAttackerWatcher;

public class MustBeBlockedByAllTargetEffect
extends RequirementEffect {
    public MustBeBlockedByAllTargetEffect(Duration duration) {
        super(duration);
        this.staticText = "all creatures able to block target creature " + (this.getDuration() == Duration.EndOfTurn ? "this turn " : "") + "do so";
    }

    protected MustBeBlockedByAllTargetEffect(MustBeBlockedByAllTargetEffect effect) {
        super(effect);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        Permanent attackingCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (attackingCreature != null && attackingCreature.isAttacking()) {
            BlockedAttackerWatcher blockedAttackerWatcher;
            if (source.getAbilityType() != AbilityType.STATIC && (blockedAttackerWatcher = game.getState().getWatcher(BlockedAttackerWatcher.class)) != null && blockedAttackerWatcher.creatureHasBlockedAttacker(attackingCreature, permanent, game)) {
                return false;
            }
            return permanent.canBlock(this.getTargetPointer().getFirst(game, source), game);
        }
        return false;
    }

    @Override
    public boolean mustAttack(Game game) {
        return false;
    }

    @Override
    public boolean mustBlock(Game game) {
        return true;
    }

    @Override
    public UUID mustBlockAttacker(Ability source, Game game) {
        return this.getTargetPointer().getFirst(game, source);
    }

    @Override
    public MustBeBlockedByAllTargetEffect copy() {
        return new MustBeBlockedByAllTargetEffect(this);
    }
}

