/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.combat;

import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetDefender;

public class ReselectDefenderAttackedByTargetEffect
extends OneShotEffect {
    private final boolean includePermanents;
    private static final FilterPermanent filter = new FilterPermanent("permanent");

    public ReselectDefenderAttackedByTargetEffect(boolean includePermanents) {
        super(Outcome.Benefit);
        this.includePermanents = includePermanents;
    }

    protected ReselectDefenderAttackedByTargetEffect(ReselectDefenderAttackedByTargetEffect effect) {
        super(effect);
        this.includePermanents = effect.includePermanents;
    }

    @Override
    public ReselectDefenderAttackedByTargetEffect copy() {
        return new ReselectDefenderAttackedByTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID id : this.getTargetPointer().getTargets(game, source)) {
            Set<UUID> defenders;
            TargetDefender defender;
            CombatGroup combatGroupTarget;
            Permanent attackingCreature = game.getPermanent(id);
            if (attackingCreature == null || (combatGroupTarget = game.getCombat().findGroup(attackingCreature.getId())) == null || !controller.chooseTarget(Outcome.Damage, defender = new TargetDefender(defenders = this.includePermanents ? game.getCombat().getDefenders() : game.getCombat().getAttackablePlayers(game).stream().collect(Collectors.toSet())), source, game)) continue;
            UUID firstTarget = defender.getFirstTarget();
            if (combatGroupTarget.getDefenderId() == null || combatGroupTarget.getDefenderId().equals(firstTarget) || !combatGroupTarget.changeDefenderPostDeclaration(firstTarget, game)) continue;
            String attacked = "";
            Player player = game.getPlayer(firstTarget);
            if (player != null) {
                attacked = player.getLogName();
            } else {
                Permanent permanent = game.getPermanent(firstTarget);
                if (permanent != null) {
                    attacked = permanent.getLogName();
                }
            }
            game.informPlayers(attackingCreature.getLogName() + " now attacks " + attacked);
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "reselect which " + (this.includePermanents ? "player or permanent " : "player ") + this.getTargetPointer().describeTargets(mode.getTargets(), "that creature") + " is attacking";
    }

    static {
        filter.add(Predicates.or(CardType.PLANESWALKER.getPredicate(), CardType.BATTLE.getPredicate()));
    }
}

