/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.AttachmentType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class AddCardColorAttachedEffect
extends ContinuousEffectImpl {
    private final ObjectColor addedColor;

    public AddCardColorAttachedEffect(ObjectColor addedColor, AttachmentType attachmentType) {
        super(Duration.WhileOnBattlefield, Layer.ColorChangingEffects_5, SubLayer.NA, Outcome.Benefit);
        this.addedColor = addedColor;
        this.staticText = attachmentType.verb() + " creature is " + addedColor.getDescription() + " in addition to its other colors";
    }

    protected AddCardColorAttachedEffect(AddCardColorAttachedEffect effect) {
        super(effect);
        this.addedColor = effect.addedColor;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent target;
        Permanent equipment = game.getPermanent(source.getSourceId());
        if (equipment != null && equipment.getAttachedTo() != null && (target = game.getPermanent(equipment.getAttachedTo())) != null) {
            if (this.addedColor.isBlack()) {
                target.getColor(game).setBlack(true);
            }
            if (this.addedColor.isBlue()) {
                target.getColor(game).setBlue(true);
            }
            if (this.addedColor.isWhite()) {
                target.getColor(game).setWhite(true);
            }
            if (this.addedColor.isGreen()) {
                target.getColor(game).setGreen(true);
            }
            if (this.addedColor.isRed()) {
                target.getColor(game).setRed(true);
            }
        }
        return true;
    }

    @Override
    public AddCardColorAttachedEffect copy() {
        return new AddCardColorAttachedEffect(this);
    }
}

