/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledCreatureSpell;
import mage.filter.common.FilterOwnedCreatureCard;
import mage.game.Game;
import mage.game.command.CommandObject;
import mage.game.command.Commander;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;

public class AddCreatureSubTypeAllMultiZoneEffect
extends ContinuousEffectImpl {
    private final FilterControlledCreaturePermanent filterPermanent;
    private final FilterControlledCreatureSpell filterSpell;
    private final FilterOwnedCreatureCard filterCard;
    private final SubType chosenType;

    public AddCreatureSubTypeAllMultiZoneEffect(FilterControlledCreaturePermanent filterPermanent, FilterControlledCreatureSpell filterSpell, FilterOwnedCreatureCard filterCard) {
        this(filterPermanent, filterSpell, filterCard, null);
    }

    public AddCreatureSubTypeAllMultiZoneEffect(FilterControlledCreaturePermanent filterPermanent, FilterControlledCreatureSpell filterSpell, FilterOwnedCreatureCard filterCard, SubType chosenType) {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.filterPermanent = filterPermanent;
        this.filterSpell = filterSpell;
        this.filterCard = filterCard;
        this.chosenType = chosenType;
        String typeMessage = "the chosen type";
        if (chosenType != null) {
            typeMessage = chosenType.getPluralName();
        }
        this.staticText = filterPermanent.getMessage() + " are " + typeMessage + " in addition to their other types. The same is true for " + filterSpell.getMessage() + " and " + filterCard.getMessage() + " that aren't on the battlefield";
    }

    private AddCreatureSubTypeAllMultiZoneEffect(AddCreatureSubTypeAllMultiZoneEffect effect) {
        super(effect);
        this.filterPermanent = effect.filterPermanent;
        this.filterSpell = effect.filterSpell;
        this.filterCard = effect.filterCard;
        this.chosenType = effect.chosenType;
    }

    @Override
    public AddCreatureSubTypeAllMultiZoneEffect copy() {
        return new AddCreatureSubTypeAllMultiZoneEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Card card;
        UUID controllerId = source.getControllerId();
        Player controller = game.getPlayer(controllerId);
        SubType subType = this.chosenType;
        if (subType == null) {
            subType = ChooseCreatureTypeEffect.getChosenCreatureType(source.getSourceId(), game);
        }
        if (controller == null || subType == null) {
            return false;
        }
        for (UUID cardId : controller.getGraveyard()) {
            card = game.getCard(cardId);
            if (!this.filterCard.match(card, controllerId, source, game) || card.hasSubtype(subType, game)) continue;
            game.getState().getCreateMageObjectAttribute(card, game).getSubtype().add(subType);
        }
        for (UUID cardId : controller.getHand()) {
            card = game.getCard(cardId);
            if (!this.filterCard.match(card, controllerId, source, game) || card.hasSubtype(subType, game)) continue;
            game.getState().getCreateMageObjectAttribute(card, game).getSubtype().add(subType);
        }
        for (Card card2 : game.getState().getExile().getCardsOwned(game, controllerId)) {
            if (!this.filterCard.match(card2, controllerId, source, game) || card2.hasSubtype(subType, game)) continue;
            game.getState().getCreateMageObjectAttribute(card2, game).getSubtype().add(subType);
        }
        for (Card card2 : controller.getLibrary().getCards(game)) {
            if (!this.filterCard.match(card2, controllerId, source, game) || card2.hasSubtype(subType, game)) continue;
            game.getState().getCreateMageObjectAttribute(card2, game).getSubtype().add(subType);
        }
        for (CommandObject commandObject : game.getState().getCommand()) {
            if (!(commandObject instanceof Commander) || !this.filterCard.match(card = game.getCard(commandObject.getId()), controllerId, source, game) || card.hasSubtype(subType, game)) continue;
            game.getState().getCreateMageObjectAttribute(card, game).getSubtype().add(subType);
        }
        for (StackObject stackObject : game.getStack()) {
            if (!(stackObject instanceof Spell) || !this.filterSpell.match(stackObject, controllerId, source, game) || stackObject.hasSubtype(subType, game)) continue;
            card = ((Spell)stackObject).getCard();
            game.getState().getCreateMageObjectAttribute(card, game).getSubtype().add(subType);
        }
        List<Permanent> creatures = game.getBattlefield().getAllActivePermanents(this.filterPermanent, controllerId, game);
        for (Permanent creature : creatures) {
            if (creature == null) continue;
            creature.addSubType(game, subType);
        }
        return true;
    }
}

