/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.AnyColorManaAbility;
import mage.abilities.mana.BlackManaAbility;
import mage.abilities.mana.BlueManaAbility;
import mage.abilities.mana.GreenManaAbility;
import mage.abilities.mana.RedManaAbility;
import mage.abilities.mana.WhiteManaAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class BecomesAllBasicsControlledEffect
extends ContinuousEffectImpl {
    private static final Ability[] basicManaAbilities = new Ability[]{new WhiteManaAbility(), new BlueManaAbility(), new BlackManaAbility(), new RedManaAbility(), new GreenManaAbility()};

    public BecomesAllBasicsControlledEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Detriment);
        this.staticText = "Lands you control are every basic land type in addition to their other types";
        this.dependendToTypes.add(DependencyType.BecomeNonbasicLand);
        this.dependencyTypes.add(DependencyType.BecomeMountain);
        this.dependencyTypes.add(DependencyType.BecomeForest);
        this.dependencyTypes.add(DependencyType.BecomeSwamp);
        this.dependencyTypes.add(DependencyType.BecomeIsland);
        this.dependencyTypes.add(DependencyType.BecomePlains);
    }

    private BecomesAllBasicsControlledEffect(BecomesAllBasicsControlledEffect effect) {
        super(effect);
    }

    @Override
    public BecomesAllBasicsControlledEffect copy() {
        return new BecomesAllBasicsControlledEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND, source.getControllerId(), game)) {
            permanent.addSubType(game, SubType.PLAINS, SubType.ISLAND, SubType.SWAMP, SubType.MOUNTAIN, SubType.FOREST);
            for (Ability basicManaAbility : basicManaAbilities) {
                if (!permanent.getAbilities(game).containsRule(basicManaAbility)) continue;
                permanent.removeAbility(basicManaAbility, source.getSourceId(), game);
            }
            AnyColorManaAbility ability = new AnyColorManaAbility();
            if (permanent.getAbilities(game).containsRule(ability)) continue;
            permanent.addAbility(ability, source.getSourceId(), game);
        }
        return true;
    }
}

