/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.choices.ChoiceColor;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

public class BecomesColorSourceEffect
extends ContinuousEffectImpl {
    private ObjectColor setColor;

    public BecomesColorSourceEffect(Duration duration) {
        this(null, duration);
    }

    public BecomesColorSourceEffect(ObjectColor setColor, Duration duration) {
        super(duration, Layer.ColorChangingEffects_5, SubLayer.NA, Outcome.Benefit);
        this.setColor = setColor;
    }

    protected BecomesColorSourceEffect(BecomesColorSourceEffect effect) {
        super(effect);
        this.setColor = effect.setColor;
    }

    @Override
    public BecomesColorSourceEffect copy() {
        return new BecomesColorSourceEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            this.discard();
            return;
        }
        if (this.setColor == null) {
            ChoiceColor choice = new ChoiceColor();
            if (!controller.choose(Outcome.PutManaInPool, choice, game)) {
                this.discard();
                return;
            }
            this.setColor = choice.getColor();
            if (!game.isSimulation()) {
                game.informPlayers(controller.getLogName() + " has chosen the color: " + this.setColor.toString());
            }
        }
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (this.setColor != null) {
            MageObject sourceObject = game.getObject(source);
            if (sourceObject != null) {
                sourceObject.getColor(game).setColor(this.setColor);
            } else {
                this.discard();
            }
            return true;
        }
        return false;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "{this} becomes " + (this.setColor == null ? "the color of your choice" : this.setColor.getDescription()) + (this.duration.toString().isEmpty() ? "" : " " + this.duration.toString());
    }
}

