/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.TargetController;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class CantGainLifeAllEffect
extends ContinuousEffectImpl {
    private TargetController targetController;

    public CantGainLifeAllEffect() {
        this(Duration.WhileOnBattlefield);
    }

    public CantGainLifeAllEffect(Duration duration) {
        this(duration, TargetController.ANY);
    }

    public CantGainLifeAllEffect(Duration duration, TargetController targetController) {
        super(duration, Layer.PlayerEffects, SubLayer.NA, Outcome.Benefit);
        this.targetController = targetController;
        this.staticText = this.setText();
    }

    protected CantGainLifeAllEffect(CantGainLifeAllEffect effect) {
        super(effect);
        this.targetController = effect.targetController;
    }

    @Override
    public CantGainLifeAllEffect copy() {
        return new CantGainLifeAllEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        switch (this.targetController) {
            case YOU: {
                controller.setCanGainLife(false);
                break;
            }
            case NOT_YOU: {
                for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                    Player player2 = game.getPlayer(playerId);
                    if (player2 == null || player2.equals(controller)) continue;
                    player2.setCanGainLife(false);
                }
                break;
            }
            case OPPONENT: {
                for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                    Player player3;
                    if (!controller.hasOpponent(playerId, game) || (player3 = game.getPlayer(playerId)) == null) continue;
                    player3.setCanGainLife(false);
                }
                break;
            }
            case ANY: {
                for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                    Player player4 = game.getPlayer(playerId);
                    if (player4 == null) continue;
                    player4.setCanGainLife(false);
                }
                break;
            }
            case ENCHANTED: {
                Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).map(Permanent::getAttachedTo).map(game::getPlayer).ifPresent(player -> player.setCanGainLife(false));
            }
        }
        return true;
    }

    private String setText() {
        StringBuilder sb = new StringBuilder();
        switch (this.targetController) {
            case YOU: {
                sb.append("You");
                break;
            }
            case NOT_YOU: {
                sb.append("Other players");
                break;
            }
            case OPPONENT: {
                sb.append("Your opponents");
                break;
            }
            case ANY: {
                sb.append("Players");
                break;
            }
            case ENCHANTED: {
                sb.append("enchanted player");
            }
        }
        sb.append(" can't gain life");
        if (!this.duration.toString().isEmpty()) {
            sb.append(' ');
            if (this.duration == Duration.EndOfTurn) {
                sb.append("this turn");
            } else {
                sb.append(this.duration.toString());
            }
        }
        return sb.toString();
    }
}

