/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

public class GainAllCreatureTypesTargetEffect
extends ContinuousEffectImpl {
    public GainAllCreatureTypesTargetEffect(Duration duration) {
        super(duration, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Neutral);
    }

    protected GainAllCreatureTypesTargetEffect(GainAllCreatureTypesTargetEffect effect) {
        super(effect);
    }

    @Override
    public GainAllCreatureTypesTargetEffect copy() {
        return new GainAllCreatureTypesTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        int affectedTargets = 0;
        for (UUID permanentId : this.getTargetPointer().getTargets(game, source)) {
            Permanent target = game.getPermanent(permanentId);
            if (target == null) continue;
            target.setIsAllCreatureTypes(game, true);
            ++affectedTargets;
        }
        return affectedTargets > 0;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return this.getTargetPointer().describeTargets(mode.getTargets(), "it") + " gains all creature types " + this.duration.toString();
    }
}

