/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;

public class GainControlAllControlledTargetEffect
extends OneShotEffect {
    private final FilterPermanent filter;

    public GainControlAllControlledTargetEffect(FilterPermanent filter) {
        super(Outcome.GainControl);
        this.filter = filter;
    }

    protected GainControlAllControlledTargetEffect(GainControlAllControlledTargetEffect effect) {
        super(effect);
        this.filter = effect.filter;
    }

    @Override
    public GainControlAllControlledTargetEffect copy() {
        return new GainControlAllControlledTargetEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        FilterPermanent filterForPlayer = this.filter.copy();
        filterForPlayer.add(new ControllerIdPredicate(player.getId()));
        return new GainControlAllEffect(Duration.EndOfGame, filterForPlayer, source.getControllerId()).apply(game, source);
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        String text = "gain control of all " + this.filter.getMessage() + " ";
        text = text + this.getTargetPointer().describeTargets(mode.getTargets(), "that player");
        text = text + " controls";
        return text;
    }
}

