/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.condition.Condition;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class GainControlTargetEffect
extends ContinuousEffectImpl {
    protected UUID controllingPlayerId;
    private final boolean fixedControl;
    private boolean firstControlChange = true;
    private final Condition condition;

    public GainControlTargetEffect(Duration duration) {
        this(duration, false, null);
    }

    public GainControlTargetEffect(Duration duration, boolean fixedControl) {
        this(duration, fixedControl, null);
    }

    public GainControlTargetEffect(Duration duration, UUID controllingPlayerId) {
        this(duration, true, controllingPlayerId);
    }

    public GainControlTargetEffect(Duration duration, boolean fixedControl, UUID controllingPlayerId) {
        this(duration, fixedControl, controllingPlayerId, null);
    }

    public GainControlTargetEffect(Duration duration, boolean fixedControl, UUID controllingPlayerId, Condition condition) {
        super(duration, Layer.ControlChangingEffects_2, SubLayer.NA, Outcome.GainControl);
        this.controllingPlayerId = controllingPlayerId;
        this.fixedControl = fixedControl;
        this.condition = condition;
    }

    protected GainControlTargetEffect(GainControlTargetEffect effect) {
        super(effect);
        this.controllingPlayerId = effect.controllingPlayerId;
        this.fixedControl = effect.fixedControl;
        this.condition = effect.condition;
        this.firstControlChange = effect.firstControlChange;
    }

    @Override
    public GainControlTargetEffect copy() {
        return new GainControlTargetEffect(this);
    }

    @Override
    public void init(Ability source, Game game) {
        if (this.controllingPlayerId == null && this.fixedControl) {
            this.controllingPlayerId = source.getControllerId();
        }
        super.init(source, game);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            this.discard();
            return false;
        }
        boolean oneTargetStillExists = false;
        for (UUID permanentId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null) continue;
            oneTargetStillExists = true;
            if (permanent.isControlledBy(this.controllingPlayerId)) continue;
            boolean controlChanged = false;
            if (this.controllingPlayerId != null) {
                if (permanent.changeControllerId(this.controllingPlayerId, game, source)) {
                    controlChanged = true;
                }
            } else if (permanent.changeControllerId(source.getControllerId(), game, source)) {
                controlChanged = true;
            }
            if (this.firstControlChange && !controlChanged) {
                this.discard();
            }
            if (this.condition == null || this.condition.apply(game, source)) continue;
            this.discard();
        }
        if (!oneTargetStillExists || !controller.isInGame()) {
            this.discard();
        }
        this.firstControlChange = false;
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "gain control of " + this.getTargetPointer().describeTargets(mode.getTargets(), "that creature") + (this.duration.toString().isEmpty() || this.duration == Duration.EndOfGame ? "" : " " + this.duration.toString());
    }
}

