/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.common.continuous.GainAbilityAllEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.choices.ChoiceColor;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class GainProtectionFromColorAllEffect
extends GainAbilityAllEffect {
    protected ChoiceColor choice;

    public GainProtectionFromColorAllEffect(Duration duration, FilterPermanent filter) {
        super(new ProtectionAbility(new FilterCard()), duration, filter);
        this.choice = new ChoiceColor(true);
    }

    protected GainProtectionFromColorAllEffect(GainProtectionFromColorAllEffect effect) {
        super(effect);
        this.choice = effect.choice.copy();
    }

    @Override
    public GainProtectionFromColorAllEffect copy() {
        return new GainProtectionFromColorAllEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        FilterCard protectionFilter = (FilterCard)((ProtectionAbility)this.ability).getFilter();
        protectionFilter.add(new ColorPredicate(this.choice.getColor()));
        protectionFilter.setMessage(this.choice.getChoice());
        ((ProtectionAbility)this.ability).setFilter(protectionFilter);
        return super.apply(game, source);
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
        MageObject sourceObject = game.getObject(source);
        Player controller = game.getPlayer(source.getControllerId());
        if (sourceObject != null && controller != null) {
            if (!controller.choose(Outcome.Protect, this.choice, game)) {
                this.discard();
                return;
            }
            game.informPlayers(sourceObject.getLogName() + ": " + controller.getLogName() + " has chosen protection from " + this.choice.getChoice());
        }
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "Choose a color. " + CardUtil.getTextWithFirstCharUpperCase(this.filter.getMessage()) + " gain protection from the chosen color " + this.duration.toString();
    }
}

