/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.RetraceAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

public class GainRetraceYourGraveyardEffect
extends ContinuousEffectImpl {
    private final FilterCard filter;

    public GainRetraceYourGraveyardEffect(FilterCard filter) {
        this(Duration.WhileOnBattlefield, filter);
    }

    public GainRetraceYourGraveyardEffect(Duration duration, FilterCard filter) {
        super(duration, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.filter = filter;
        this.staticText = filter.getMessage() + " in your graveyard have retrace.";
    }

    private GainRetraceYourGraveyardEffect(GainRetraceYourGraveyardEffect effect) {
        super(effect);
        this.filter = effect.filter;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID cardId : controller.getGraveyard()) {
            Card card = game.getCard(cardId);
            if (card == null) continue;
            for (Card faceCard : CardUtil.getCastableComponents(card, this.filter, source, controller, game, null, false)) {
                RetraceAbility ability = new RetraceAbility(faceCard);
                ability.setSourceId(cardId);
                ability.setControllerId(faceCard.getOwnerId());
                game.getState().addOtherAbility(faceCard, ability);
            }
        }
        return true;
    }

    @Override
    public GainRetraceYourGraveyardEffect copy() {
        return new GainRetraceYourGraveyardEffect(this);
    }
}

