/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.effects.common.continuous;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.util.CardUtil;

public final class HasSubtypesSourceEffect
extends ContinuousEffectImpl {
    private final List<SubType> subtypes = new ArrayList<SubType>();

    public HasSubtypesSourceEffect(SubType ... subTypes) {
        super(Duration.EndOfGame, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.subtypes.addAll(Arrays.asList(subTypes));
    }

    protected HasSubtypesSourceEffect(HasSubtypesSourceEffect effect) {
        super(effect);
        this.subtypes.addAll(effect.subtypes);
    }

    @Override
    public HasSubtypesSourceEffect copy() {
        return new HasSubtypesSourceEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = game.getObject(source);
        if (sourceObject == null) {
            return false;
        }
        for (SubType subType : this.subtypes) {
            sourceObject.addSubType(game, subType);
        }
        return true;
    }

    @Override
    public String getText(Mode mode) {
        if (this.staticText != null && !this.staticText.isEmpty()) {
            return this.staticText;
        }
        return "{this} is also " + this.subtypes.get(0).getIndefiniteArticle() + ' ' + CardUtil.concatWithAnd(this.subtypes.stream().map(SubType::getDescription).collect(Collectors.toList()));
    }

    public boolean hasSubtype(SubType subType) {
        return this.subtypes.contains((Object)subType);
    }
}

